/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import GameState.GameState;
import GameState.GameStateManager;
import TileMap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class GameOverState
extends GameState {
    private Background bg;
    private int currentChoice = 0;
    private String[] options = new String[]{"Menu", "Quit"};
    private Color titleColor;
    private Font titleFont;
    private Font font;

    public GameOverState(GameStateManager gsm) {
        this.gsm = gsm;
        try {
            this.bg = new Background("/Backgrounds/Dead.png", 0.0);
            this.titleColor = new Color(250, 0, 0);
            this.titleFont = new Font("Boulder", 0, 30);
            this.font = new Font("Arial", 0, 14);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.bg.update();
    }

    @Override
    public void draw(Graphics2D graphics) {
        this.bg.draw(graphics);
        graphics.setColor(this.titleColor);
        graphics.setFont(this.titleFont);
        graphics.drawString("Game Over", 80, 70);
        graphics.setFont(this.font);
        int i = 0;
        while (i < this.options.length) {
            if (i == this.currentChoice) {
                graphics.setColor(Color.BLUE);
            } else {
                graphics.setColor(Color.WHITE);
            }
            graphics.drawString(this.options[i], 145, 140 + i * 15);
            ++i;
        }
    }

    private void select() {
        if (this.currentChoice == 0) {
            this.gsm.setState(0);
        }
        if (this.currentChoice == 1) {
            System.exit(0);
        }
    }

    @Override
    public void keyPressed(int k) {
        if (k == 10) {
            this.select();
        }
        if (k == 38) {
            --this.currentChoice;
            if (this.currentChoice == -1) {
                this.currentChoice = this.options.length - 1;
            }
        }
        if (k == 40) {
            ++this.currentChoice;
            if (this.currentChoice == this.options.length) {
                this.currentChoice = 0;
            }
        }
    }

    @Override
    public void keyReleased(int k) {
    }
}

